<?php

namespace App\Controllers;


class TipoPago extends BaseController
{

	public function index(){

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded'
			)
		);
		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'tipopagoindex', false, $contexto);
		$resultado_tipo_pago=json_decode($resultado,true);

		if($resultado_tipo_pago['code']==200){
			$datos=array(
				'datos_tipo_pago'=>$resultado_tipo_pago['data'],
			);
		}else{
			$datos=array(
				'mensaje'=>'No hay datos',
				'datos_tipo_pago'=>[],
			);
		}


		echo view("layouts/header");
		echo view("layouts/aside");
		echo view("tipopago/vistatipopago",$datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$tipopago = $_POST["tipopago"];
		$descripciontipopago = $_POST["descripciontipopago"];

		$datos_post = http_build_query(
			array(
				"tip_tipo_pago"=> $tipopago,
				"tip_descripcion"=> $descripciontipopago,
				"tip_estado"=> 1,
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'tipopagocreate', false, $contexto);
		$resultado=json_decode($resultado,true);  

		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Agregado con exito');
				return redirect()->to(base_url('TipoPago')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de agregar');
				return redirect()->to(base_url('TipoPago')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('TipoPago')); 
		}     

	}

	

	public function editar(){
		$session = \Config\Services::session();
		$tipopago = $_POST["editartipopago"];		
		$descripciontipopago = $_POST["editardescripciontipopago"];		
		$tipid = $_POST["editartipid"];
		
		$datos_post = http_build_query(
			array(
				"tip_tipo_pago"=> $tipopago,
				"tip_descripcion"=> $descripciontipopago,
				"tip_estado"=> 1,
				"tip_id"=>$tipid,
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',	
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'tipopagoactualizar', false, $contexto);
		$resultado=json_decode($resultado,true); 
		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Editado con exito');
				return redirect()->to(base_url('TipoPago')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de editar');
				return redirect()->to(base_url('TipoPago')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('TipoPago')); 
		} 
	}

	public function eliminar($id){
		$session = \Config\Services::session();
		
		$datos_post = http_build_query(
			array(				
				"tip_id"=>$id,
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',	
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'tipopagoeliminar', false, $contexto);
		$resultado=json_decode($resultado,true); 
		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Eliminado con exito');
				return redirect()->to(base_url('TipoPago')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de eliminar');
				return redirect()->to(base_url('TipoPago')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('TipoPago')); 
		} 
	}
}