<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Descuentomensualvalormodel;
use App\Models\Convenioporcentajemodel;
use App\Models\Postconveniovalormodel;
use App\Models\Puntoventamodel;

class Cargavalores extends BaseController
{

	public function index(){
		

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("cargavalores/leervalores");
		echo view("layouts/footer");
		echo view("cargavalores/excel");
		echo view("cargavalores/footer");
	}

	

    public function guardarDatos() {
        $session = \Config\Services::session();
        $PuntoVentaModel=new Puntoventamodel();
        // Recibir los datos enviados por AJAX
        $datosDetalleProducto = $this->request->getPost('datosdetalleproducto');
        $cabecera = $this->request->getPost('cabecera1');
        $mes=$this->request->getPost('mes');

        if (!empty($datosDetalleProducto)) {
            $datos = json_decode($datosDetalleProducto, true);  // Convertir JSON a array 
            

            // Aquí deberías tener tu lógica para:
            // 1. Verificar los puntos de venta
            // 2. Verificar los descuentos, convenios y postconvenios
            // 3. Registrar los datos en las tablas correspondientes
            // 4. Retornar una respuesta de éxito o error
            $contColumna=0;
            foreach ($datos['rows'] as $fila) {
                // Ejemplo de cómo verificar e insertar los datos de cada fila
                $puntoVenta = $PuntoVentaModel->getPuntoventasegunnombre($fila[0])[0];
                
                if ($puntoVenta) {
                    // Procesar el descuento/convenio/postconvenio
                    $this->procesarFila($fila, $puntoVenta['puv_id'],$contColumna,$cabecera,$mes);
                } else {
                    // Punto de venta no encontrado, generar alerta o mensaje
                    //json_encode(['success' => false, 'message' => 'Punto de venta no encontrado '.$fila[0]]);
                    //return;
                }
                $contColumna;
            }

            // Retornar una respuesta de éxito
            $session->setFlashdata('mensaje_bueno', 'Datos guardados exitosamente');
        } else {
            // Si no se recibieron datos
             $session->setFlashdata('mensaje_malo', 'No se recibieron datos');
        }
        $datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("cargavalores/leervalores");
		echo view("layouts/footer");
		echo view("cargavalores/excel");
		echo view("cargavalores/footer");
    }

    private function procesarFila($fila, $puntoVenta,$contColumna,$cabecera,$mes) {
        $DescuentoModel=new Descuentomensualvalormodel();
        $ConvenioModel=new Convenioporcentajemodel();
        $PostConvenioModel=new Postconveniovalormodel();
        // Aquí haces el cálculo y la inserción en la base de datos según el tipo
        // de descuento, convenio o postconvenio

        // Verificar si es descuento, convenio o postconvenio
        $mes=$mes.'-01';
        $cabecera=json_decode($cabecera, true); 
        
       
        foreach ($fila as $key => $value) {
            if (is_int($key) && $key!=0) {
                 $fila['tipo']=$cabecera[0][$key];
                 $fila['nombre']=$cabecera[1][$key];
                 $fila['valor']=$fila[$key];
                 //echo '<pre>';print_r($fila);echo "</pre>";
                 if($fila['valor']!=0){ 
                     if ($fila['tipo'] == 'Descuento') {
                    $DescuentoModel->insertarDescuento($puntoVenta, $fila['nombre'], $fila['valor'],$mes);
                    } elseif ($fila['tipo'] == 'Convenio') {
                        $ConvenioModel->insertarConvenio($puntoVenta, $fila['nombre'], $fila['valor'],$mes);
                    } elseif ($fila['tipo'] == 'Postconvenio') {
                        $PostConvenioModel->insertarPostConvenio($puntoVenta, $fila['nombre'], $fila['valor'],$mes);
                    }
                 }
            }
        }
        
        
    }


	
		
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}