<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Ciudadmodel;

class Ciudad extends BaseController
{

	public function index(){
		$ciudad_model= new Ciudadmodel();
		$datos_ciudad=$ciudad_model->getCiudad();


		$enviar_datos=array(
			'datos_ciudad' => !empty($datos_ciudad)?$datos_ciudad:null , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("ciudad/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$ciudad_model= new Ciudadmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('ciudad'))){
				$ciu_ciudad=$this->request->getPost('ciudad');
				$ingresar_datos=array(
					'ciu_ciudad'=>$ciu_ciudad,
					'ciu_estado'=>1
				);
				$ciudad_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Ciudad')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Ciudad')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$ciudad_model= new Ciudadmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editciudad')) && !empty($this->request->getPost('editciuid'))){
				$ciu_ciudad=$this->request->getPost('editciudad');
				$ciu_id=$this->request->getPost('editciuid');
				$editar_datos=array(
					'ciu_ciudad'=>$ciu_ciudad,
					'ciu_estado'=>1
				);
				$ciudad_model->actualizar($ciu_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Ciudad')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Ciudad')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$ciudad_model= new Ciudadmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'ciu_estado'=>0
				);
				$ciudad_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Ciudad')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Ciudad')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
		
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}