<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Basecomisionesmodel extends Model
{
     
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_base_comisiones');
        $builder->set($data);
		$builder->insert();

    }
    public function getBasecomisionespormes($mes,$tipo)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_base_comisiones');
        $builder->select('tbl_base_comisiones.*,tbl_punto_venta.*,tbl_iva_renta_pdv.*,tbl_porcenjate_comision.*');  
        $builder->join('tbl_punto_venta', 'tbl_base_comisiones.puv_id=tbl_punto_venta.puv_id'); 
        $builder->join('tbl_iva_renta_pdv', 'tbl_punto_venta.irp_id=tbl_iva_renta_pdv.irp_id'); 
        $builder->join('tbl_porcenjate_comision', 'tbl_punto_venta.pco_id=tbl_porcenjate_comision.pco_id'); 
        $builder->where('tbl_base_comisiones.bac_mes', $mes);
        if($tipo!=2)
        {
            $builder->where('tbl_punto_venta.puv_propio', $tipo);
        }
        $builder->orderBy('tbl_punto_venta.puv_punto_venta', 'ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function getBasecomisionespormespuvid($puv_id,$mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_base_comisiones');
        $builder->select('tbl_base_comisiones.*,tbl_punto_venta.*,tbl_iva_renta_pdv.*,tbl_porcenjate_comision.*'); 
        $builder->join('tbl_punto_venta', 'tbl_base_comisiones.puv_id=tbl_punto_venta.puv_id'); 
        $builder->join('tbl_iva_renta_pdv', 'tbl_punto_venta.irp_id=tbl_iva_renta_pdv.irp_id');
        $builder->join('tbl_porcenjate_comision', 'tbl_punto_venta.pco_id=tbl_porcenjate_comision.pco_id');
        $builder->where('tbl_base_comisiones.bac_mes', $mes); 
        $builder->where('tbl_base_comisiones.puv_id', $puv_id);    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 

    public function actualizar($bac_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_base_comisiones');
        $builder->where('tbl_base_comisiones.bac_id', $bac_id);
        return $builder->update($data);        
    }

    public function eliminar($bac_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_base_comisiones');
        $builder->where('tbl_base_comisiones.bac_mes', $bac_mes);
        return $builder->delete();        
    }

    
   

}