<?php

namespace App\Models;

use CodeIgniter\Model;

class Cotizacionmodel extends Model
{
    protected $table = 'cotizacion_cabecera';  // Tabla para almacenar la cabecera de la cotización
    protected $primaryKey = 'ctc_id';
    protected $allowedFields = [
        'ctc_id', 
        'ctc_id_cotizacion', 
        'ctc_almacen', 
        'ctc_punto_emision',
        'ctc_fecha_transaccion', 
        'ctc_dni_cliente', 
        'ctc_nombre_cliente', 
        'ctc_secuencial_cotizacion', 
        'ctc_secuencial_factura', 
        'ctc_total', 
        'ctc_subtotal'
    ];

    protected $db; // Conexión a la base de datos PostgreSQL

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect('postgres');
    }

    // Verificar si la cotización ya existe por secuencial de cotización
    public function existeCotizacion($secuencialCotizacion,$fechatransaccion,$dnicliente)
    {
        $conditions = [
            'ctc_secuencial_cotizacion' => $secuencialCotizacion,
            'ctc_fecha_transaccion' =>$fechatransaccion,
            'ctc_dni_cliente' =>$dnicliente
        ];
        return $this->where($conditions)->first();
    }

    // Insertar una nueva cabecera de cotización si no existe
    public function insertarCotizacionCabecera($data)
{
    // Verificar si la cotización ya existe
    if (!$this->existeCotizacion($data['ctc_secuencial_cotizacion'], $data['ctc_fecha_transaccion'], $data['ctc_dni_cliente'])) {
        // Construir la consulta SQL de inserción manualmente
        $sql = "
            INSERT INTO cotizacion_cabecera (
                ctc_id_cotizacion,
                ctc_almacen,
                ctc_punto_emision,
                ctc_fecha_transaccion,
                ctc_dni_cliente,
                ctc_nombre_cliente,
                ctc_secuencial_cotizacion,
                ctc_total,
                ctc_subtotal,
                trc_secuencial
            ) VALUES (
                :ctc_id_cotizacion:,
                :ctc_almacen:,
                :ctc_punto_emision:,
                :ctc_fecha_transaccion:,
                :ctc_dni_cliente:,
                :ctc_nombre_cliente:,
                :ctc_secuencial_cotizacion:,
                :ctc_total:,
                :ctc_subtotal:,
                :trc_secuencial:
            )
        ";

        // Ejecutar la consulta SQL
        $this->db->query($sql, $data);

        // Verificar si ocurrió un error
        $error = $this->db->error();
        if ($error['code'] != 0) {
            log_message('error', 'Error al insertar cotización cabecera: ' . $error['message']);
            return false;
        }

        // Retornar el último ID insertado
        return $this->db->insertID();
    }

    // Retornar false si ya existe
    return false;
}


    // Insertar los detalles de la cotización
    public function insertarCotizacionDetalle($data)
    {
        $this->db->table('cotizacion_detalle')->insert($data);

        // Capturar y manejar errores
        $error = $this->db->error();
        if ($error['code'] != 0) {
            echo 'Error en la consulta de detalle: ' . $error['message'];
            log_message('error', 'Error en la inserción de cotizacion_detalle: ' . $error['message']);
            return false;
        }
        return true;
    }
}
