<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Prestamosmodel extends Model
{
    public function getPrestamos()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*, tbl_punto_venta.*, detalle.*, detallepagadas.*, detallependientes.*');
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id = tbl_punto_venta.puv_id');
        $builder->join('tbl_prestamo_amortizacion', 'tbl_prestamos.pre_id = tbl_prestamo_amortizacion.pre_id AND tbl_prestamo_amortizacion.pra_estado = 1');
        $builder->join('(SELECT MIN(prd_id) AS prd_id, pra_id, prd_cuota_total FROM tbl_prestamo_amortizacion_detalle WHERE prd_estado = 0 GROUP BY pra_id) AS detalle', 'detalle.pra_id = tbl_prestamo_amortizacion.pra_id', 'left');
        $builder->join('(SELECT COUNT(prd_id) AS pagadas, SUM(prd_abono_cuota) AS valorpagado, pra_id FROM tbl_prestamo_amortizacion_detalle WHERE prd_estado in (1,2) GROUP BY pra_id) AS detallepagadas', 'detallepagadas.pra_id = tbl_prestamo_amortizacion.pra_id', 'left');
        $builder->join('(SELECT COUNT(prd_id) AS pendientes, SUM(prd_cuota_total) AS valorpendiente, pra_id FROM tbl_prestamo_amortizacion_detalle WHERE prd_estado = 0 GROUP BY pra_id) AS detallependientes', 'detallependientes.pra_id = tbl_prestamo_amortizacion.pra_id', 'left');
        $builder->where('tbl_prestamo_amortizacion.pra_estado', 1);  
        $query = $builder->get();
        $resultado = $query->getResultArray();
        return $resultado;
    }    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->set($data);
		$builder->insert();
		
		$builder = $db->table('tbl_prestamos');
        $builder->selectMax('tbl_prestamos.pre_id');   
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;

    }
    public function getSoloPrestamos()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*');   
        $builder->where('tbl_prestamos.pre_estado', 1); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getPrestamosById($pre_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*, tbl_punto_venta.puv_punto_venta');  
        $builder->join('tbl_punto_venta', 'tbl_prestamos.puv_id=tbl_punto_venta.puv_id');
        $builder->where('tbl_prestamos.pre_id', $pre_id);
        $builder->orderBy('tbl_prestamos.prd_numero_cuota', 'ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUnPrestamosnombrepuvid($pre_nombre,$puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*');  
        $builder->where('tbl_prestamos.pre_nombre', $pre_nombre);
        $builder->where('tbl_prestamos.puv_id', $puv_id);  
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUnPrestamosidpuvid($pre_id,$puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*');  
        $builder->where('tbl_prestamos.puv_id', $puv_id); 
        $builder->where('tbl_prestamos.pre_id', $pre_id); 
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function getPrestamosdesdehasta($pre_fecha_desde,$pre_fecha_hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.*');    
        $builder->where('tbl_prestamos.pre_fecha_desde <=', $pre_fecha_desde); 
        $builder->where('tbl_prestamos.pre_fecha_hasta >=', $pre_fecha_hasta); 
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPrestamosdesdehastaDistinct($pre_fecha_desde,$pre_fecha_hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.pre_nombre');    
        $builder->distinct();
        $builder->where('tbl_prestamos.pre_fecha_desde <=', $pre_fecha_desde); 
        $builder->where('tbl_prestamos.pre_fecha_hasta >=', $pre_fecha_hasta);
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPrestamosPendientes()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.pre_nombre');    
        $builder->distinct();
        $builder->where('tbl_prestamos.pre_estado', 1);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getPrestamosPendientesPDV($puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->select('tbl_prestamos.pre_nombre');    
        $builder->distinct();
        $builder->where('tbl_prestamos.pre_estado', 1);
        $builder->where('tbl_prestamos.puv_id', $puv_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function actualizar($pre_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->where('tbl_prestamos.pre_id', $pre_id);
        return $builder->update($data);        
    }
    public function eliminar($pre_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamos');
        $builder->where('tbl_prestamos.pre_id', $pre_id);   
        $builder->delete();        
    }

}