<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Objetivonegociadomodel;

class Objetivonegociado extends BaseController
{

	public function index(){
		$objetivo_negociado_model= new Objetivonegociadomodel();
		$datos_objetivo_negociado=$objetivo_negociado_model->getObjetivonegociado();

		$enviar_datos=array(
			'datos_objetivo_negociado' => !empty($datos_objetivo_negociado)?$datos_objetivo_negociado:null , 
		);
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("objetivonegociado/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$objetivo_negociado_model= new Objetivonegociadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('objetivo'))){
				$obn_objetivo=$this->request->getPost('objetivo');
				$ingresar_datos=array(
					'obn_objetivo'=>$obn_objetivo,
					'obn_estado'=>1
				);
				$objetivo_negociado_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Objetivonegociado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Objetivonegociado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$objetivo_negociado_model= new Objetivonegociadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editobjetivo')) && !empty($this->request->getPost('editobnid'))){
				$obn_objetivo=$this->request->getPost('editobjetivo');
				$obn_id=$this->request->getPost('editobnid');
				$editar_datos=array(
					'obn_objetivo'=>$obn_objetivo,
					'obn_estado'=>1
				);
				$objetivo_negociado_model->actualizar($obn_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Objetivonegociado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Objetivonegociado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$objetivo_negociado_model= new Objetivonegociadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'obn_estado'=>0
				);
				$objetivo_negociado_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Objetivonegociado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Objetivonegociado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	

	
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}