<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Rolmenumodel;
use App\Models\Datospersonalesmodel;

class Rolmenu extends BaseController
{

	public function index(){
		
        $rolmenu_model=new Rolmenumodel();
        $usuario_model=new Usuariomodel();
        $datos_rolmenu=$rolmenu_model->getRolMenu();
        $datos_rol=$rolmenu_model->getRol();
        $datos_menu=$rolmenu_model->getMenu();
        $datos_usuarios=$usuario_model->getUsuarioComisiones();
        
		$enviar_datos=array(
			'datos_rolmenu' => !empty($datos_rolmenu)?$datos_rolmenu:null , 
			'datos_rol' => !empty($datos_rol)?$datos_rol:null ,
			'datos_menu' => !empty($datos_menu)?$datos_menu:null ,
			'datos_usuarios' => !empty($datos_usuarios)?$datos_usuarios:null ,
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("rolmenu/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$rolmenu_model= new Rolmenumodel();
		if(!empty($this->request->getPost('rol'))&&!empty($this->request->getPost('menid'))){
			$rol_nombre=$this->request->getPost('rol');
			$ingresar_datos=array(
				'rol_nombre'=>$rol_nombre,
				'rol_estado'=>1
			);
			$rol_id=$rolmenu_model->insertarRol($ingresar_datos);
			$rol_id=$rol_id[0]['ROL_ID'];
			$men_id=$this->request->getPost('menid');
			for($i=0;$i<count($men_id);$i++)
			{
			    $ingresar_datos=array(
				'rol_id'=>$rol_id,
				'men_id'=>$men_id[$i],
				'rom_estado'=>1
			    );
			    $rolmenu_model->insertarMenuRol($ingresar_datos);
			}
			
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Rolmenu')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Rolmenu')); 
		} 
		


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$rolmenu_model= new Rolmenumodel();
		
		if(!empty($this->request->getPost('editrol')) && !empty($this->request->getPost('editmenid'))){
			$rol_id=$this->request->getPost('editrolid');
			$rol_nombre=$this->request->getPost('editrol');
			$editar_datos=array(
				'rol_nombre'=>$rol_nombre,
				'rol_sistema'=>2,
				'rol_estado'=>1
			);
			$rolmenu_model->actualizarRol($rol_id,$editar_datos);
			
			$rolmenu_model->eliminarRolMenu($rol_id);
			
			$men_id=$this->request->getPost('editmenid');
			for($i=0;$i<count($men_id);$i++)
			{
			    $ingresar_datos=array(
				'rol_id'=>$rol_id,
				'men_id'=>$men_id[$i],
				'rom_estado'=>1
			    );
			    $rolmenu_model->insertarMenuRol($ingresar_datos);
			}
			$session->setFlashdata('mensaje_bueno', 'Rol/privilegios editados');
			return redirect()->to(base_url('Rolmenu')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
			return redirect()->to(base_url('Rolmenu')); 
		} 
		
	}
    
    public function addUsuario(){
		$session = \Config\Services::session();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('rolid')) && !empty($this->request->getPost('correo')) && !empty($this->request->getPost('clave'))){

				$datos_personales_model=new Datospersonalesmodel();
				$usuario_model=new UsuarioModel();

				$DAP_NOMBRES=$this->request->getPost('nombres');

				$ingresar_datos_personales=array(
					'DAP_NOMBRES'=>$DAP_NOMBRES,
					'DAP_ESTADO'=>1,
				);
				$datos_personales_model->insertar($ingresar_datos_personales);

				$DAP_ID=$datos_personales_model->getMaxDAPID();
				$DAP_ID=$DAP_ID[0]['DAP_ID'];

				$USU_CORREO=$this->request->getPost('correo');
				$CAR_ID=1;
				$CAN_ID=1;
				$ROL_ID=$this->request->getPost('rolid');
				$USU_CLAVE=$this->request->getPost('clave');
                $are_id=1;
				$ingresar_datos=array(
					'DAP_ID'=>$DAP_ID,
					'USU_CORREO'=>$USU_CORREO,
					'CAR_ID'=>$CAR_ID,
					'CAN_ID'=>$CAN_ID,
					'ROL_ID'=>$ROL_ID,
					'USU_CLAVE'=>$USU_CLAVE,
					'USU_ESTADO'=>1,
					'sis_id'=>2,
					'are_id'=>$are_id,
				);
				$usuario_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Usuario/list')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Usuario/list')); 
			} 
		}else{
			return redirect()->to(base_url()); 
		}


	}
	public function editUsuario(){
		$session = \Config\Services::session();
			if(!empty($this->request->getPost('editdapid')) && !empty($this->request->getPost('editusuid')) && !empty($this->request->getPost('editnombres')) && !empty($this->request->getPost('editcorreo')) && !empty($this->request->getPost('editrolid')) ){

				$datos_personales_model=new Datospersonalesmodel();
				$usuario_model=new UsuarioModel();

				$DAP_ID=$this->request->getPost('editdapid');
				$DAP_NOMBRES=$this->request->getPost('editnombres');

				$actualizar_datos_personales=array(
					'DAP_NOMBRES'=>$DAP_NOMBRES,
					'DAP_ESTADO'=>1,
				);
				$datos_personales_model->actualizar($DAP_ID,$actualizar_datos_personales);

				$USU_ID=$this->request->getPost('editusuid');
				$USU_CORREO=$this->request->getPost('editcorreo');
				$CAR_ID=1;
				$CAN_ID=1;
				$ROL_ID=$this->request->getPost('editrolid');
				$are_id=1;
				$usu_estado=$this->request->getPost('editestado');
				
				$actualizar_datos=array(
					'USU_CORREO'=>$USU_CORREO,
					'CAR_ID'=>$CAR_ID,
					'CAN_ID'=>$CAN_ID,
					'ROL_ID'=>$ROL_ID,
					'are_id'=>$are_id,
					'USU_ESTADO'=>$usu_estado
				);

				$usuario_model->actualizar($USU_ID,$actualizar_datos);
				$session->setFlashdata('mensaje_bueno', 'Usuario actualizado');
				return redirect()->to(base_url('Rolmenu')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Rolmenu')); 
			} 
		

	}
	
	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$area_model= new Areamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'are_estado'=>0
				);
				$area_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Area')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Area')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
		
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}