<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Contratodetallemodel extends Model
{
    public function getContratodetallesegunconid($con_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_contrato_detalle');
        $builder->select('tbl_contrato_detalle.*,tbl_periodicidad.*,tbl_contrato_estado.*,tbl_tipo_negocio.*,tbl_datos_personales.*,tbl_usuario.*');   
        $builder->join('tbl_periodicidad', 'tbl_contrato_detalle.per_id=tbl_periodicidad.per_id');  
        $builder->join('tbl_contrato_estado', 'tbl_contrato_detalle.esc_id=tbl_contrato_estado.esc_id');    
        $builder->join('tbl_tipo_negocio', 'tbl_contrato_detalle.tin_id=tbl_tipo_negocio.tin_id');

        $builder->join('tbl_usuario', 'tbl_contrato_detalle.cod_negociador_interno=tbl_usuario.USU_ID');
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');


        $builder->where('tbl_contrato_detalle.con_id', $con_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_contrato_detalle');
		$builder->insert($data);
        $builder->selectMax('tbl_contrato_detalle.cod_id');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;

    }
    
    public function getContratodetalle($cod_desde,$pro_id,$cod_negociador_interno,$tin_id,$esc_id,$can_id)
    {
        //$year=date('Y'); 
        $canales=[1,$can_id];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_contrato_detalle');
        $builder->select('*'); 

        $builder->join('tbl_contrato_cabecera', 'tbl_contrato_detalle.con_id=tbl_contrato_cabecera.con_id');  
        $builder->join('tbl_proveedor', 'tbl_contrato_cabecera.pro_id=tbl_proveedor.pro_id');

        $builder->join('tbl_periodicidad', 'tbl_contrato_detalle.per_id=tbl_periodicidad.per_id');  
        $builder->join('tbl_contrato_estado', 'tbl_contrato_detalle.esc_id=tbl_contrato_estado.esc_id');    
        $builder->join('tbl_tipo_negocio', 'tbl_contrato_detalle.tin_id=tbl_tipo_negocio.tin_id');

        $builder->join('tbl_usuario', 'tbl_contrato_detalle.cod_negociador_interno=tbl_usuario.USU_ID');
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');
        
        if(!empty($can_id)){
            $builder->whereIn('tbl_contrato_cabecera.can_id', $canales);
           // $builder->orwhere('tbl_contrato_cabecera.can_id', '1');
        }
        if($cod_desde!=''){
            $builder->where('tbl_contrato_detalle.cod_desde', $cod_desde);
        }
        else
        {
           // $builder->where('YEAR(tbl_contrato_detalle.cod_desde)', $year);
        }
        if(!empty($pro_id)){
            $builder->where('tbl_contrato_cabecera.pro_id', $pro_id);
        }
        if(!empty($cod_negociador_interno)){
            $builder->where('tbl_contrato_detalle.cod_negociador_interno', $cod_negociador_interno);
        }
        if(!empty($tin_id)){
            $builder->where('tbl_contrato_detalle.tin_id', $tin_id);
        }
        if(!empty($esc_id)){
            $builder->where('tbl_contrato_detalle.esc_id', $esc_id);
        }
        


        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getContratodetalleAutorizador($cod_desde,$pro_id,$cod_negociador_interno,$tin_id)
    {
        $year=date('Y');
        $estados = [2,4,5];
        
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_contrato_detalle');
        $builder->select('tbl_contrato_detalle.*,tbl_periodicidad.*,tbl_contrato_estado.*,tbl_tipo_negocio.*,tbl_datos_personales.*,tbl_contrato_cabecera.*,tbl_proveedor.*'); 

        $builder->join('tbl_contrato_cabecera', 'tbl_contrato_detalle.con_id=tbl_contrato_cabecera.con_id');  
        $builder->join('tbl_proveedor', 'tbl_contrato_cabecera.pro_id=tbl_proveedor.pro_id');

        $builder->join('tbl_periodicidad', 'tbl_contrato_detalle.per_id=tbl_periodicidad.per_id');  
        $builder->join('tbl_contrato_estado', 'tbl_contrato_detalle.esc_id=tbl_contrato_estado.esc_id');    
        $builder->join('tbl_tipo_negocio', 'tbl_contrato_detalle.tin_id=tbl_tipo_negocio.tin_id');

        $builder->join('tbl_usuario', 'tbl_contrato_detalle.cod_negociador_interno=tbl_usuario.USU_ID');
        $builder->join('tbl_datos_personales', 'tbl_usuario.DAP_ID=tbl_datos_personales.DAP_ID');
        
        
        $builder->whereIn('tbl_contrato_detalle.esc_id', $estados);

        if($cod_desde!=''){
            $builder->where('tbl_contrato_detalle.cod_desde', $cod_desde); $a='entra';
        }
        else
        {
            $builder->where('YEAR(tbl_contrato_detalle.cod_desde)', $year);$a="entra ano";
        }
        if(!empty($pro_id)){
            $builder->where('tbl_contrato_cabecera.pro_id', $pro_id);
        }
        if(!empty($cod_negociador_interno)){
            $builder->where('tbl_contrato_detalle.cod_negociador_interno', $cod_negociador_interno);
        }
        if(!empty($tin_id)){
            $builder->where('tbl_contrato_detalle.tin_id', $tin_id);
        }
        


        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $a;
    }
    public function getUnContratodetalle($cod_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_contrato_detalle');
        $builder->select('*'); 
        $builder->where('tbl_contrato_detalle.cod_id', $cod_id);
        $builder->join('tbl_contrato_estado', 'tbl_contrato_detalle.esc_id=tbl_contrato_estado.esc_id');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function actualizar($cod_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_contrato_detalle');
        $builder->where('tbl_contrato_detalle.cod_id', $cod_id);
        return $builder->update($data);        
    }

    public function Deletecontradodetallemodelsegunconid($con_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_contrato_detalle');
        $builder->where('tbl_contrato_detalle.con_id', $con_id);
        $builder->delete();
        
    }
    public function actualizarsegunconid($con_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_contrato_detalle');
        $builder->where('tbl_contrato_detalle.con_id', $con_id);
        return $builder->update($data);        
    }

}